package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.custom.TareaAperturasCustomDao;
import com.ejie.ab04b.dao.custom.TareaTramiteAperturasCustomDao;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TareaAperturasServiceImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Service(value = "tareaAperturasService")
public class TareaAperturasServiceImpl implements TareaAperturasService {

	@Autowired()
	private TareaAperturasCustomDao tareaAperturasDao;
	@Autowired()
	private TareaTramiteAperturasCustomDao tareaTramiteAperturasDao;

	/**
	 * Inserts a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaAperturas add(TareaAperturas tareaAperturas) {
		return this.tareaAperturasDao.add(tareaAperturas);
	}

	/**
	 * Updates a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaAperturas update(TareaAperturas tareaAperturas) {
		return this.tareaAperturasDao.update(tareaAperturas);
	}

	/**
	 * Updates a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaAperturas updateFilled(TareaAperturas tareaAperturas) {
		return this.tareaAperturasDao.updateFilled(tareaAperturas);
	}

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	public TareaAperturas find(TareaAperturas tareaAperturas) {
		return (TareaAperturas) this.tareaAperturasDao.vfind(tareaAperturas);
	}

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	public TareaAperturas findTareaTramite(TareaAperturas tareaAperturas) {
		return (TareaAperturas) this.tareaTramiteAperturasDao
				.vfind(tareaAperturas);
	}

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 *  mailboxTaskId
	 *            String
	 *  TareaAperturas
	 *
	 * @param mailboxTaskId the mailbox task id
	 * @return the tarea aperturas
	 */
	public TareaAperturas findByMailboxTaskId(String mailboxTaskId) {
		return (TareaAperturas) this.tareaAperturasDao
				.findByMailboxTaskId(mailboxTaskId);
	}

	/**
	 * Deletes a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TareaAperturas tareaAperturas) {
		this.tareaAperturasDao.remove(tareaAperturas);
	}

	/**
	 * Finds a list of rows in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaAperturas>
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TareaAperturas> findAll(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TareaAperturas>) this.tareaAperturasDao
				.vfindAll(tareaAperturas, jqGridRequestDto);
	}

	/**
	 * Finds a list of rows in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaAperturas>
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TareaAperturas> findAllTareatramite(
			TareaAperturas tareaAperturas, JQGridRequestDto jqGridRequestDto) {
		return (List<TareaAperturas>) this.tareaTramiteAperturasDao
				.vfindAll(tareaAperturas, jqGridRequestDto);
	}

	/**
	 * Finds rows in the TareaAperturas table using like.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TareaAperturas>
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TareaAperturas> findAllLike(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<TareaAperturas>) this.tareaAperturasDao
				.findAllLike(tareaAperturas, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the TareaAperturas table.
	 * 
	 *  filterTareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<TareaAperturas>
	 *
	 * @param filterTareaAperturas the filter tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<TareaAperturas> filter(
			TareaAperturas filterTareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<TareaAperturas> listaTareaAperturas = this.tareaAperturasDao
				.findAllLike(filterTareaAperturas, jqGridRequestDto, false);
		Long recordNum = this.tareaAperturasDao
				.findAllLikeCount(filterTareaAperturas != null
						? filterTareaAperturas : new TareaAperturas(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TareaAperturas>> reorderSelection = this.tareaAperturasDao
					.reorderSelection(filterTareaAperturas, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<TareaAperturas>(jqGridRequestDto,
					recordNum, listaTareaAperturas, reorderSelection);
		}
		return new JQGridResponseDto<TareaAperturas>(jqGridRequestDto,
				recordNum, listaTareaAperturas);
	}

	/**
	 * Searches rows in the TareaAperturas table.
	 * 
	 *  filterTareaAperturas
	 *            TareaAperturas
	 *  searchTareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaAperturas>>
	 *
	 * @param filterTareaAperturas the filter tarea aperturas
	 * @param searchTareaAperturas the search tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<TareaAperturas>> search(
			TareaAperturas filterTareaAperturas,
			TareaAperturas searchTareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tareaAperturasDao.search(filterTareaAperturas,
				searchTareaAperturas, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in TareaAperturas table.
	 * 
	 *  filterTareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTareaAperturas the filter tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(TareaAperturas filterTareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tareaAperturasDao.reorderSelection(filterTareaAperturas,
				jqGridRequestDto, startsWith);
	}

}
